unit Unit1;

interface

{==============================================================================}
{ This demo show how to use information about hypertext item.                  }
{------------------------------------------------------------------------------}
{ Key methods:                                                                 }
{ - GetJumpPointLocation;                                                      }
{ - methods for obtaining information about items (see first demo in this      }
{   group.                                                                     }
{ Useful if text is self-describing (for example, for WWW addresses).          }
{==============================================================================}

{$I RV_Defs.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  {$IFDEF RICHVIEWDEF4}
  ImgList,
  {$ENDIF}
  RVStyle, ExtCtrls, RVScroll, RichView, StdCtrls, CRVFData, SclRView;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    RVStyle1: TRVStyle;
    ImageList1: TImageList;
    Image1: TImage;
    srv: TSRichViewEdit;
    procedure FormCreate(Sender: TObject);
    procedure RichView1Jump(Sender: TObject; id: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var ico: TIcon;
begin
  srv.SetMargin(5, 5, 5, 5);

  srv.RichViewEdit.AddNL('Hypertext',1,1);
  srv.RichViewEdit.AddNL('Some text styles can be chosen as hypertext styles. ',0,0);
  srv.RichViewEdit.AddNL('Like this one.',4,-1);
  srv.RichViewEdit.AddNL(' You can have as many hypertext styles as you want.  ',0,-1);
  srv.RichViewEdit.AddNL('Here is one more.',5,-1);
  srv.RichViewEdit.AddNL('Images from Image Lists also can be hypertext: ',0,0);
  srv.RichViewEdit.AddHotspotEx('Pen Image', 0,1, ImageList1, -1);
  srv.RichViewEdit.AddNL(' Such images are called "hotspots".',0,-1);
  srv.RichViewEdit.AddNL('Normal images also can be hypertext: ',0,0);
  ico := TIcon.Create;
  ico.Assign(Image1.Picture.Graphic);
  srv.RichViewEdit.AddHotPicture('Bobo', ico, -1, rvvaBaseLine);

  srv.RichViewEdit.Format;
end;

procedure TForm1.RichView1Jump(Sender: TObject; id: Integer);
var RVData: TCustomRVFormattedData;
    ItemNo: Integer;
begin
  srv.RichViewEdit.GetJumpPointLocation(id, RVData, ItemNo);
  Panel1.Caption := 'Clicked: '+RVData.GetItemText(ItemNo);
end;

end.
